'''
    This script is used to create an order of the scenes and the dataset while
    excluding the corrupted scenes in exclude.py
    This should be re-run everytime the exluded scenes are changes.
'''

import json
import os

ALL_EXCLUDED_SEQUENCES = {}

if __name__ == '__main__':

    dataset_map_fname = "dataset_map.json"
    raw_dataset_path = ""
    location_of_dataset_map = ""

    categories = ["car"]
    dataset_map = {}

    for category in categories:
        dataset_map[category] = []
        
        all_scene_ids = os.listdir(os.path.join(raw_dataset_path))
        all_scene_ids.sort()
        for scene_id in all_scene_ids: 

            category_exluded_scenes = ALL_EXCLUDED_SEQUENCES.get(category, [])
            is_excluded = scene_id in category_exluded_scenes
            
            if not is_excluded:
                dataset_map[category].append(scene_id)


    with open(os.path.join(location_of_dataset_map, dataset_map_fname), 'w') as file:
        json.dump(dataset_map, file, indent=4)  

